#############################################################################
# Title:        web_server.pl
# Description:  A low function web server to serve snapshots generated with
#               snapshot2.pl or to server up log files converted to html with
#               log2html.pl.
# Authors:      Phil Scales
#               Jason Morio
# Date:         10/1/98
#############################################################################

BEGIN {
	unshift(@INC, "$ENV{DAZEL_HOME}/lib/perl5");
}

use Socket;
use Getopt::Long;
use File::Basename;

sub main()
{
	GetOptions("h", "p=s", "f=s"); 
	$program = basename($0, "");
	if ($opt_h) { help() && usage() && exit 0 };
	if ($opt_p) {
		$server_port = $opt_p;
	}
	else {
		$server_port = 8089;
	}
	CreateServer($server_port);
}
sub CreateServer($)
{
	my $server_port = shift;
	$doc_root = "scripts";

	socket(SERVER, PF_INET, SOCK_STREAM, getprotobyname('tcp'));
	setsockopt(SERVER, SOL_SOCKET, SO_REUSEADDR, 1);
	$my_addr = sockaddr_in($server_port, INADDR_ANY);
	($my_port, $my_packed_ip) = sockaddr_in($my_addr);
	$my_dotted_quad = inet_ntoa($my_packed_ip);
	bind(SERVER, $my_addr) or die "Couldn't bind to port $server_port : $!\n";

	listen(SERVER, SOMAXCONN) or die "Couldn't listen on port $server_port : $!\n";
	print STDOUT "Server listening on port $server_port\n";
	while ($client_addr = accept(CLIENT, SERVER)) {
		($port, $packed_ip) = sockaddr_in($client_addr);
		$dotted_quad = inet_ntoa($packed_ip);
		
# the first line of the CLIENT data has the GET file to spit back out.		
		TRY: {
			while(<CLIENT>) { 	

# the end of the CLIENT header terminates with a \n 2-byte string.  
# When we get this, send our data to the client, 

				if (! (length($_) -2) ) { 
					$reply = "HTTP/1.0 200 OK\nMIME-Version: 1.0\nContent-Type: text/html\n\n";
					last;
				}
				if (/^GET/) {
					($method, $url, $proto) = ($_ =~ /^(GET) \/(.*) (\S+)/);
					$url =~ s/^\///;
					if ($url eq "" && $opt_f) {
						if (-e $opt_f) {
							$url = $opt_f;
						}
					}
					elsif ($url eq "") {
						$url = "index.html";
					}
					open(DOC, "<$url");	
					foreach (<DOC>) { 
						$SIG{PIPE} = sub { redo TRY };
						print CLIENT $_; 
					}
					close DOC;
				}
			}
		}
		close(CLIENT);
	}
	print STDERR "Closing server.\n";
	close SERVER;
}
sub help()
{
  open(MORE, "|more");
	print MORE<<END; 
===========================================================================
	Program:      $program
	Description:  A simple web server to serve snapshot2.pl and log2html.pl 
	              output.
===========================================================================

Summary:
-------
A simple web server to serve snapshot2.pl and log2html.pl output.

Description:
-----------
By default $program listens on port 8088.  If this port is not available
execute:

   \$ perl $program -p <port>

To accept the default port number use the following syntax:

   \$ perl $program

By default $program will look for a file called index.html in the directory
from which it's being run.  To specify a single file to server with 
$program use the -f option:

   \$ perl $program -p <port> -f <filename>
	
You are then ready to connect to server with your PC's Netscape web browser
by typing into it's location field:

     <hostname>:<port>

When you are done you can terminate the server by entering <CTRL-C> in the 
login session where you are running the sever since the server runs in the 
foreground.

END
close MORE;

}
sub usage()
{
	print STDOUT "Usage:  perl $program\n";
	print STDOUT "                [ -p <port_number> ] Port number for server to\n";
	print STDOUT "                                     listen on.  Default is 8088\n";
	print STDOUT "                [ -f <filename> ]    Port number for server to\n";
	print STDOUT "                [ -h ]               Display help.\n\n";

}

main();
